local assets=
{
	Asset("ANIM", "anim/estus_empty.zip"),
	Asset("ATLAS", "images/inventoryimages/estus_empty.xml"),
}

local prefabs=
{

}

local function ininventory (inst, owner)
	STRINGS.ACTIONS.COOK = "Cook"
end

local function oncursor (inst)
	STRINGS.ACTIONS.COOK = "Refill"
end

local function on_cook(inst, cooker, chef)
	chef.components.sanity:DoDelta(5) 
	chef.components.hunger:DoDelta(-35)
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    inst.AnimState:SetBank("estus_empty")
    inst.AnimState:SetBuild("estus_empty")
    inst.AnimState:PlayAnimation("idle")
    MakeInventoryPhysics(inst)
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/estus_empty.xml"
	inst.components.inventoryitem:SetOnActiveItemFn ( oncursor )
	inst.components.inventoryitem:SetOnPutInInventoryFn ( ininventory )
	
	inst:AddComponent("cookable")
    inst.components.cookable.product = "estus_full"
	inst.components.cookable:SetOnCookedFn( on_cook )
	
    return inst
end

return Prefab( "common/inventory/estus_empty", fn, assets, prefabs)









